          { FAST! MACHINE CODE DRIVER FOR 640x480x16 VIDEO MODE }
                   { (C) MIODRAG MALOVIC  1995-96. }

program expg16lib; uses crt; {heap 192K}
type memtype=array[1..65512] of byte; ptype=array[0..15] of byte;
var i,j,k,txtcol,getwin:byte; q,w,n,prx,pry,xa,xb,ya,yb:word; charptr:pointer;
sm1,sm2,sm3:^memtype; f:file; zx,zy:string[79];
gd,gm,ii:integer; label l1,l2,l3,l4;

const tvm:word=$A000;
{mishmask:array[0..31] of word=($9FFF,$8FFF,$87FF,$83FF,$81FF,$80FF,
$807F,$803F,$801F,$800F,$80FF,$887F,$987F,$FC3F,$FC3F,$FE3F, 0,$2000,$3000,
$3800,$3C00,$3E00,$3F00,$3F80,$3FC0,$3E00,$3600,$2300,$300,$180,$180,0);}
paldat:array[0..15] of array[0..2] of byte=( (0,0,0), (63,16,16), (0,16,0),
(0,16,16), (16,0,0), (40,30,20), (20,15,10), (30,23,16), (16,16,16), (63,63,0),
(4,4,4), (12,12,12), (18,18,18), (25,25,25), (35,35,35), (63,63,63) );
defaultpal:ptype=(0,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1);
pal9_14:ptype=(0,0,0,0, 0,0,0,0, 0,1,1,1, 1,1,1,0);
pal_win:ptype=(0,0,0,0, 0,0,0,1, 0,0,0,0, 0,0,0,1);

procedure CHARACTERS; external; {$L plcchar.obj}
procedure INIT; assembler; asm; MOV AX,$12; INT 16; XOR AX,AX; MOV prx,AX;
 MOV pry,AX end;
procedure PALETESET; assembler; asm; MOV BX,15; @0:PUSH BX; MOV BH,BL;
 MOV AX,$1000; INT 16; POP BX; DEC BX; JNZ @0 end;
procedure PAL256; assembler; asm; MOV BX,15; @0:MOV AX,$1000; PUSH BX;
 MOV BH,BL; INT 16; POP BX; DEC BX; JNZ @0; LEA DX,paldat; PUSH DS; POP ES;
 SUB BX,BX; MOV CX,16; MOV AX,$1012; INT 16 end;
procedure RETRACE; assembler; asm; MOV DX,$3DA; @1:IN AL,DX; TEST AL,8;
 JZ @1 end;
procedure QUIT(zz:String); begin textmode(co80); writeln(zz); halt end;
procedure BIP; begin sound(500); delay(400); nosound end;
procedure WAIT; begin bip; readkey end;
procedure WA27; begin if readkey=chr(27) then quit('') end;

procedure COLOR(col:byte); assembler; asm; MOV DX,$3CE; XOR AX,AX;
 OUT DX,AX; MOV AX,$FF01; OUT DX,AX; MOV AH,col; XOR AL,AL; OUT DX,AX end;

procedure POLI(x1,y1,x2,y2:word); assembler; var r1,r2:word; asm;
 PUSH DS; MOV ES,tvm; MOV DS,tvm;
 MOV AX,80; MUL y1; MOV BX,x1; MOV CL,BL; SHR BX,3; ADD BX,AX; MOV SI,BX; {1}
 MOV BX,x2; MOV DL,BL; SHR BX,3; ADD BX,AX; {2}
 CMP BX,SI; JC @X; JNZ @1; {check}
  MOV AX,x2; STC; SBB AX,x1; JC @X; {single byte}
  MOV AH,$FF; AND CL,7; SHR AH,CL; MOV AL,AH; MOV CL,DL; AND CL,7;
  MOV AH,$7F; SHR AH,CL; XOR AH,255; AND AH,AL; MOV AL,8; MOV DX,$3CE;
  MOV CX,y2; SUB CX,y1; INC CX; OUT DX,AX; MOV SI,80; @2:OR [BX],AH;
  ADD BX,SI; LOOP @2; JMP @X; {now double byte}
@1:XCHG BX,SI; MOV r1,BX; MOV r2,SI;
  PUSH DX; MOV AH,255; AND CL,7; SHR AH,CL; MOV AL,8; MOV DX,$3CE; OUT DX,AX;
  MOV CX,y2; SUB CX,y1; INC CX; MOV DI,80; @3:OR [BX],AH; ADD BX,DI; LOOP @3;
  XCHG BX,SI; MOV AH,$7F; POP CX; AND CL,7; SHR AH,CL; XOR AH,255; OUT DX,AX;
  MOV CX,y2; SUB CX,y1; INC CX; @4:OR [BX],AH; ADD BX,DI; LOOP @4;
{now middle bytes}
MOV CX,r2; STC; SBB CX,r1; JZ @X; INC r1; MOV SI,CX; MOV AX,y1; DEC AX;
SUB y2,AX; CLD; MOV AX,$FF08; OUT DX,AX; @L:MOV CX,SI;
MOV DI,r1; REP STOSB; DEC y2; JZ @X; ADD r1,80; JMP @L;
@X:POP DS end;

procedure RECTANG(x1,y1,x2,y2:word); assembler;
var r1,r2,r3,r4:word; b1,b2:byte; asm;
 PUSH DS; MOV CX,y2; STC; SBB CX,y1; JC @X; MOV r3,CX; MOV ES,tvm; MOV DS,tvm;
 MOV AX,80; MUL y1; MOV BX,x1; MOV CL,BL; SHR BX,3; ADD BX,AX; MOV SI,BX; {1}
 MOV BX,x2; MOV DL,BL; SHR BX,3; ADD BX,AX; {2}
 CMP BX,SI; JC @X; JNZ @1; {check}
  MOV AX,x2; STC; SBB AX,x1; JC @X; {single byte}
  MOV AX,$FF80; AND CL,7; SHR AH,CL; SHR AL,CL; MOV b1,AL;
   MOV b2,AH; MOV CL,DL; AND CL,7;
  MOV AX,$7F80; SHR AH,CL; SHR AL,CL; XOR AH,255; AND AH,b2;
   MOV b2,AL; MOV AL,8; MOV DX,$3CE;
  MOV CX,r3; OUT DX,AX; MOV r1,AX; MOV SI,80;
  OR [BX],AH; ADD BX,SI; JCXZ @N; MOV AH,b1; OR AH,b2; OUT DX,AX;
  @2:OR [BX],AH; ADD BX,SI; LOOP @2;  
  @N:MOV AX,r1; OUT DX,AX; OR [BX],AH; JMP @X;
@1:XCHG BX,SI; MOV r1,BX; MOV r2,SI; {this is double byte+}
  PUSH DX; MOV AX,$FF80; AND CL,7; SHR AH,CL; SHR AL,CL; MOV b1,AL;
   MOV AL,8; MOV DX,$3CE; OUT DX,AX; MOV r4,AX; MOV DI,80;
  MOV CX,r3; OR [BX],AH; ADD BX,DI; JCXZ @3;
   MOV AH,b1; OUT DX,AX; @5:OR [BX],AH; ADD BX,DI; LOOP @5;
   MOV AX,r4; OUT DX,AX; @3:OR [BX],AH;
  XCHG BX,SI; MOV AX,$7F80; POP CX; AND CL,7; SHR AH,CL; SHR AL,CL;
   XOR AH,255; MOV b1,AL; MOV AL,8; OUT DX,AX; MOV r4,AX;
  MOV CX,r3; OR [BX],AH; ADD BX,DI; JCXZ @4;
   MOV AH,b1; OUT DX,AX; @6:OR [BX],AH; ADD BX,DI; LOOP @6;
   MOV AX,r4; OUT DX,AX; @4:OR [BX],AH;
{now middle bytes}
MOV CX,r2; STC; SBB CX,r1; JZ @X; INC r1; MOV SI,CX; CLD; MOV AX,$FF08;
OUT DX,AX; MOV DI,r1; REP STOSB; MOV CX,80; MOV AX,r3; INC AX; MUL CX;
MOV DI,r1; ADD DI,AX; MOV CX,SI; REP STOSB; @X:POP DS end;

procedure LINEHOR(x1,y1,len:word); assembler; asm;
 CMP len,0; JZ @xx; MOV AX,x1; ADD AX,len; CMP AX,641; JC @O1;
 MOV AX,640; SUB AX,x1; MOV len,AX; {end check}
@O1:PUSH DS; MOV ES,tvm; MOV SI,len; MOV DS,tvm; MOV AX,80; MUL y1;
 MOV BX,x1; MOV CX,BX; SHR BX,3; ADD BX,AX; AND CX,7; XOR DX,DX;
 MOV AL,255; SHR AL,CL; MOV AH,AL; MOV CX,8; @0:SHR AL,1; ADC DL,CH;
 LOOP @0; MOV CX,SI; SUB SI,DX; SUB DX,CX; JC @OK;
  MOV CX,DX; JCXZ @9; @1:STC; RCL DH,1; LOOP @1; {single byte}
  XOR AH,DH; @9:MOV AL,8; MOV DX,$3CE; OUT DX,AX; OR [BX],AH; JMP @X;
 @OK:MOV DX,$3CE; MOV AL,8; OUT DX,AX; OR [BX],AH;
 MOV AX,$FF08; OUT DX,AX; INC BX; MOV CX,SI;
 SHR CX,3; JCXZ @E; CLD; MOV DI,BX; REP STOSB; MOV BX,DI; {middle}
 @E:MOV CX,SI; AND CX,7; JZ @X; XOR AH,AH; @3:STC; RCR AH,1; LOOP @3;
 OUT DX,AX; OR [BX],AH; @X:POP DS; @XX:end;

procedure LINEVER(x1,y1,len:word); assembler; asm;
 CMP len,0; JZ @xx; MOV AX,y1; ADD AX,len; CMP AX,481; JC @O1;
 MOV AX,480; SUB AX,x1; MOV len,AX;
@O1:PUSH DS; MOV ES,tvm; MOV DS,tvm; MOV AX,80; MUL y1; MOV BX,x1;
 MOV CX,BX; SHR BX,3; ADD BX,AX; AND CX,7; MOV AX,$8008; SHR AH,CL;
 MOV DX,$3CE; OUT DX,AX; MOV CX,len; MOV SI,80; @0:OR [BX],AH; ADD BX,SI;
 LOOP @0; @X:POP DS; @XX:end;

procedure PUTPIX(x,y:word;b:byte); assembler; asm; MOV DX,$3CE; MOV AX,$FF01;
 OUT DX,AX; MOV AH,b; SUB AL,AL; OUT DX,AX; MOV AX,80; MUL y; MOV BX,x;
 MOV CX,BX; SHR BX,3; ADD BX,AX; MOV ES,tvm; MOV DX,$3CE; AND CL,7;
 MOV AX,$8008; SHR AH,CL; OUT DX,AX; OR ES:[BX],AH end;

procedure WRAT(a1,a2:WORD;zz:string); assembler; var r1:byte;
asm;LES AX,DWORD PTR prx; ADD a1,AX; MOV AX,ES; ADD a2,AX;
 LES BX,[BP+4]; XOR CH,CH; MOV CL,ES:[BX]; MOV DX,$3CE;
 @0:PUSH CX; INC BX; MOV AL,ES:[BX]; PUSH BX; PUSH ES; PUSH DS; LES SI,charptr;
 MOV DS,tvm; XOR AH,AH; SHL AX,4; ADD SI,AX; MOV AX,a2; SHL AX,4; MOV DI,AX;
 SHL AX,2; ADD AX,DI; MOV DI,a1; XOR CX,CX; SHR DI,1; RCR CL,1; SHR DI,1;
 RCR CL,1; SHR DI,1; RCL CL,3; ADD DI,AX; MOV r1,16; MOV AL,8; @1:
 MOV BL,ES:[SI]; INC SI; XOR BH,BH; ROR BX,CL; MOV AH,BL; OUT DX,AX;
 OR [DI],AH; MOV AH,BH; OUT DX,AX; OR [DI+1],AH; ADD DI,80; DEC r1; JNZ @1;
 POP DS; POP ES; POP BX; POP CX; ADD a1,9; DEC CX; JNZ @0 end;

procedure WRAC(a1,a2:WORD;zz:string); assembler; var r1:byte;
asm;LES AX,DWORD PTR prx; ADD a1,AX; MOV AX,ES; ADD a2,AX;
 LES BX,[BP+4]; XOR CH,CH; MOV CL,ES:[BX]; MOV DX,$3CE;
 MOV AX,CX; SHL AX,3; ADD AX,CX; SHR AX,1; SUB a1,AX; @0:PUSH CX; INC BX;
 MOV AL,ES:[BX]; PUSH BX; PUSH ES; PUSH DS; LES SI,charptr; MOV DS,tvm;
 XOR AH,AH; SHL AX,4; ADD SI,AX; MOV AX,a2; SHL AX,4; MOV DI,AX; SHL AX,2;
 ADD AX,DI; MOV DI,a1; XOR CX,CX; SHR DI,1; RCR CL,1; SHR DI,1; RCR CL,1;
 SHR DI,1; RCL CL,3; ADD DI,AX; MOV r1,16; MOV AL,8; @1:MOV BL,ES:[SI]; INC SI;
 XOR BH,BH; ROR BX,CL; MOV AH,BL; OUT DX,AX; OR [DI],AH; MOV AH,BH; OUT DX,AX;
 OR [DI+1],AH; ADD DI,80; DEC r1; JNZ @1; POP DS; POP ES; POP BX; POP CX;
 ADD a1,9; DEC CX; JNZ @0 end;

procedure OTVORIPROZOR(x1,y1,x2,y2:word;col:byte); begin
 color(col); poli(x1+2,y1+2,x2-2,y2-2); prx:=x1; pry:=y1; getwin:=col;
 color(14); linehor(x1,y1,succ(x2-x1));
            linehor(succ(x1),succ(y1),pred(x2-x1));
 color(13); linever(x1,succ(y1),pred(y2-y1));
            linever(succ(x1),y1+2,y2-y1-3);
 color(11); linehor(x1,y2,succ(x2-x1));
            linehor(succ(x1),pred(y2),pred(x2-x1));
 color(12); linever(x2,succ(y1),pred(y2-y1));
            linever(pred(x2),y1+2,y2-y1-3) end;

procedure SAVESCR(x1,y1,x2,y2:word; where,defp:pointer);
 label err,errpop; var xlen,ylen,x1adr:word; svv:byte; begin; asm;
CLD; MOV AX,x1; AND AX,$F8; MOV x1,AX; MOV AX,x2; OR AX,7; INC AX; MOV x2,AX;
SUB AX,x1; JC err; JZ err; MOV xlen,AX; MOV BX,y2; SUB BX,y1; JNG err;
INC BX; MOV ylen,BX; MUL BX; SHR DX,1; RCR AX,1; SHR DX,1; RCR AX,1;
SHR DX,1; RCR AX,1; TEST DX,DX; JNZ err; PUSH DS; PUSH AX; LDS SI,defp; INC SI;
MOV CX,15; MOV AH,DH; @C:LODSB; ADD DX,AX; LOOP @C; POP AX; MUL DX;
AND DX,DX; JNZ errpop; CMP AX,65501; JNC errpop;
{ check over: calc & make header }
MOV AX,80; MUL y1; MOV BX,x1; SHR BX,3; ADD AX,BX; SHR xlen,3; MOV x1adr,AX;
LES DI,where; STOSW; MOV AX,xlen; STOSW; MOV AX,ylen; STOSW; LDS AX,defp;
STOSW; MOV AX,DS; STOSW; MOV DX,$3CE; MOV AL,5; OUT DX,AL; INC DX; IN AL,DX;
MOV svv,AL; MOV AL,9; OUT DX,AL; DEC DX; MOV CX,$A000; MOV DS,CX;
{ loop color planes }
MOV CX,1; @0:PUSH CX; PUSH ylen; MOV AX,ES; LES SI,defp;
ADD SI,CX; OR ES:[SI],CH; MOV ES,AX; JZ @00; MOV AL,2; MOV AH,CL; OUT DX,AX;
MOV BX,x1adr; @19:MOV SI,BX; MOV CX,xlen; REP MOVSB; ADD BX,80;
DEC ylen; JNZ @19; @00:POP ylen; POP CX; INC CX; CMP CX,16; JC @0;
LES BX,where; SUB DI,BX;
{ on exit restore mode state and ds }
MOV DX,$3CE; MOV AL,5; MOV AH,svv; OUT DX,AX; POP DS; MOV w,DI; end; exit;
errpop:asm; POP DS end;
err:quit('Too large image: save screen routine error') end;

procedure LOADSCR(ptx:pointer); assembler; var xlen,ylen,x1adr:word;
ptrsav:pointer; svv:byte; asm;
 PUSH DS; CLD; MOV ES,tvm; LDS SI,ptx; LODSW; MOV x1adr,AX; LODSW;
 MOV xlen,AX; LODSW; MOV ylen,AX; LODSW; MOV WORD PTR ptrsav,AX; LODSW;
 MOV WORD PTR ptrsav+2,AX; MOV CX,1; MOV DX,$3CE; MOV AL,5; OUT DX,AL; INC DX;
 IN AL,DX; MOV svv,AL; XOR AL,AL; OUT DX,AL; DEC DX;
{ loop part }
@0:PUSH DS; LDS BX,ptrsav; ADD BX,CX; OR [BX],CH; POP DS; JZ @00;
 PUSH CX; PUSH ylen; MOV AH,CL; MOV AL,CH; OUT DX,AX; MOV BX,x1adr;
 @15:MOV DI,BX; MOV CX,xlen; MOV AL,8; @4:MOV AH,[SI]; OUT DX,AX;
 OR ES:[DI],AH; INC DI; INC SI; LOOP @4; ADD BX,80; DEC ylen; JNZ @15;
 POP ylen; POP CX; @00:INC CX; TEST CL,16; JZ @0; POP DS; MOV AH,svv;
 MOV AL,5; OUT DX,AX end;

procedure SCROLLDOWN(x1,y1,y2:word;col:byte;zz:string); begin
 color(col); wrat(x1,y1,zz); retrace;
 for y1:=y1 to pred(y2) do begin retrace;
  color(getwin); wrat(x1,y1,zz); color(col); wrat(x1,succ(y1),zz) end end;



BEGIN 
new(sm1); new(sm2); new(sm3); randomize; charptr:=@characters; W:=0;
init; pal256;
for q:=0 to 512 do begin xa:=random(624); ya:=random(464);
  for w:=10 to 15 do putpix(xa+w,ya+w,w) end; readkey;

color(6); poli(0,0,639,479); otvoriprozor(30,30,250,250,7);
scrolldown(33,40,140,15,'scroll'); scrolldown(115,40,140,15,'enabled');
wait; savescr(50,120,230,200,sm1,@pal_win);
otvoriprozor(400,70,600,180,3); color(1); wrac(100,47,'262144 colors');
l4:otvoriprozor(50,120,230,200,5); color(15); wrac(90,32,'fast screen pop');
if readkey<>chr(27) then begin loadscr(sm1);
  if readkey<>chr(27) then goto l4 end;

for q:=300 to 479 do begin color(random(16)); linehor(0,q,640) end;
repeat q:=300+random(180); color(random(16)); linehor(0,q,640)
until keypressed;
init; paleteset; l1:asm; XOR CX,CX; MOV DX,$1D4F; MOV AX,$700; XOR BX,BX;
INT 16 end; color(9+random(7));
wrac(320,464,'FAST! driver for VGA 640x480x16 mode, by Miodrag Malovi} 1996.');
for w:=0 to 4095 do begin
 if lo(w)=0 then begin
  q:=succ(random(15)); i:=12+random(52); j:=12+random(52); k:=12+random(52);
   asm; MOV BX,q; MOV CL,i; MOV CH,j; MOV DH,k; MOV AX,$1010; INT 16 end end;
xa:=random(320); xb:=320+random(320);
ya:=random(230); yb:=230+random(230);
color(succ(random(15))); rectang(xa,ya,xb,yb);
if keypressed and (readkey=chr(27)) then begin
  textmode(co80); halt end end; goto l1 end.